import { observer } from 'mobx-react';

import { useState, useEffect } from 'react';
import { SentencePartItem, sentenceParts } from '@/parts';
import SentencePart from '@/components/SentencePart';
import FinalSentence from '@/components/FinalSentence';

export const IndexPage = observer(() => {
	const [selectedParts, setSelectedParts] = useState<SentencePartItem[]>([]);
	const [currentStep, setCurrentStep] = useState(0);
	const [showFinal, setShowFinal] = useState(false);

	const handleSelect = (part: SentencePartItem) => {
		setSelectedParts([...selectedParts, part]);
		setCurrentStep(currentStep + 1);
	};

	useEffect(() => {
		if (selectedParts.length === 3) {
			setShowFinal(true);
		}
	}, [selectedParts]);

	return (
		<main className="flex min-h-screen flex-col items-center justify-center p-24 bg-gray-100">
			<h1 className="text-4xl font-bold text-center mb-8">Конструктор комплиментов</h1>
			{!showFinal ? (
				<SentencePart parts={sentenceParts[currentStep]} onSelect={handleSelect} />
			) : (
				<FinalSentence
					sentence={selectedParts.map(part => part.text).join(' ')}
					audioFiles={selectedParts.map(part => part.audioFile)}
				/>
			)}
		</main>
	);
});
