interface SentencePartItem {
	audioFile: string;
	text: string;
}

interface SentencePartProps {
	parts: SentencePartItem[] | undefined;
	onSelect: (part: SentencePartItem) => void;
}

export default function SentencePart({ parts, onSelect }: SentencePartProps) {
	if (!parts || parts.length === 0) {
		return <div>Loading...</div>;
	}

	return (
		<div className="flex flex-wrap justify-center items-center gap-4">
			{parts.map(part => (
				<button
					key={part.audioFile}
					onClick={() => onSelect(part)}
					className="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded transition duration-300"
				>
					{part.text}
				</button>
			))}
		</div>
	);
}
