import { formatNumber } from '@/lib/utils';
import clsx from 'clsx';

export const Metric = ({ value, previousValue }: { value: number; previousValue?: number | null }) => {
	return (
		<span className="text-lg">
			{formatNumber(value)}
			{previousValue && (
				<span
					title={`3 days change: ${value > previousValue ? '+' : '-'}${formatNumber(value - previousValue)}`}
					className={clsx('text-sm m-1', value > previousValue ? 'text-green-500' : 'text-red-500')}
				>
					{value > previousValue ? '↑' : '↓'}
				</span>
			)}
		</span>
	);
};
