interface AnswerButtonProps {
	answer: string;
	isSelected: boolean;
	isCorrect: boolean | null;
	onClick: (event: React.MouseEvent<HTMLButtonElement>) => void;
}

export default function AnswerButton({ answer, isSelected, isCorrect, onClick }: AnswerButtonProps) {
	let buttonClasses = 'w-full p-4 text-left rounded-lg transition-colors duration-300 ';

	if (isSelected) {
		if (isCorrect === true) {
			buttonClasses += 'bg-green-500 text-white';
		} else if (isCorrect === false) {
			buttonClasses += 'bg-red-500 text-white animate-wrong-answer';
		} else {
			buttonClasses += 'bg-blue-500 text-white';
		}
	} else {
		buttonClasses += 'bg-gray-200 hover:bg-gray-300';
	}

	return (
		<button className={buttonClasses} onClick={onClick}>
			{answer}
		</button>
	);
}
