import AnswerButton from './answer-button';

interface QuestionProps {
	question: string;
	image: string | null;
	answers: string[];
	selectedAnswerIndex: number | null;
	isCorrect: boolean | null;
	onAnswerClick: (index: number, event: React.MouseEvent) => void;
}

export default function Question({
	question,
	image,
	answers,
	selectedAnswerIndex,
	isCorrect,
	onAnswerClick,
}: QuestionProps) {
	return (
		<div className="space-y-4 w-full px-4 sm:px-6">
			<h2 className="text-2xl font-bold mb-4 w-full text-center">{question}</h2>
			{image && (
				<img
					src={image || '/placeholder.svg'}
					alt="Question"
					className="w-full max-h-[33vh] object-contain mb-4 rounded-lg"
				/>
			)}
			<div className="grid grid-cols-1 gap-4 w-full">
				{answers.map((answer, index) => (
					<AnswerButton
						key={index}
						answer={answer}
						isSelected={selectedAnswerIndex === index}
						isCorrect={isCorrect}
						onClick={e => onAnswerClick(index, e)}
					/>
				))}
			</div>
		</div>
	);
}
