import { Fragment } from 'react/jsx-runtime';
import { Outlet } from 'react-router-dom';
import Providers from './providers';
import { observer } from 'mobx-react';
import { Toaster } from '@/components/ui/toaster';
import { modalsStore } from '@/stores/Modals';

export const BaseLayout = observer(() => {
	return (
		<Providers>
			<main className="flex min-h-screen w-full flex-col bg-muted/40">
				<div className="flex flex-col sm:gap-4 max-h-screen relative overflow-auto">
					<Outlet />
				</div>
			</main>
			{modalsStore.globalElements.map(el => (
				<Fragment key={el.id}>{el.element}</Fragment>
			))}
			<Toaster />
		</Providers>
	);
});
