import { type ClassValue, clsx } from 'clsx';
import { twMerge } from 'tailwind-merge';

export function cn(...inputs: ClassValue[]) {
	return twMerge(clsx(inputs));
}

export const formatNumber = (value: number) => {
	let valueStr = value.toString();
	if (value > 1000000) {
		valueStr = `${(value / 1000000).toFixed(1)}M`;
	} else if (value > 1000) {
		valueStr = `${(value / 1000).toFixed(1)}K`;
	}
	return valueStr;
};
