import { createRoot } from 'react-dom/client';

import './layout/globals.css';

import { createBrowserRouter, RouterProvider } from 'react-router-dom';

import { IndexPage } from './(pages)/page';

import { BaseLayout } from './layout/base-layout';

const router = createBrowserRouter([
	{
		path: '/',
		element: <BaseLayout />,
		children: [
			{
				path: '/',
				element: <IndexPage />,
			},
		],
	},
]);

createRoot(document.getElementById('root')!).render(<RouterProvider router={router} />);
